@echo off
setlocal EnableDelayedExpansion
echo:
echo Flash Tool for RoentDek HV3
echo:

:PROMPT
SET AREYOUSURE=N
SET /P AREYOUSURE=Really flash the HV3 device firmware? (y/[n])? 
IF /I "%AREYOUSURE%" NEQ "y" GOTO end_
echo:

echo (Please wait a few seconds.)
echo:

REM Count Arduino Due Programming devices
get_COM_port.exe Arduino Due Programming Port

set port=%errorlevel%

if %port% EQU -2 goto AAA
if %port% EQU -1 goto BBB
if %port% EQU 0 goto BBB



MODE COM%port%:1200,N,8,1
timeout /T 1 > nul

if exist HV3_firmware.ino.arduino_due_x.bin (
   bossac.exe -i --port=COM%port% -U false -e -w -b HV3_firmware.ino.arduino_due_x.bin -R
) else (
   bossac.exe -i --port=COM%port% -U false -e -w -b HV3_firmware.bin -R
)

echo:
echo:
echo Flashing done.

echo:
pause
exit


:AAA
echo Error: Too many Arduino Due devices found.
echo (Only connect the HV3 that must be flashed.)
echo:
pause
exit


:BBB
echo Error: No HV3 found for flashing.
echo:
pause
exit

:end_
echo The firmware upgrade was aborted.
echo:
pause
exit
